#pragma once

#include <travel/hotels/proto/promo_service/promo_service.grpc.pb.h>

#include <travel/hotels/lib/cpp/mon/counter.h>
#include <travel/hotels/lib/cpp/grpc/grpc_async_client.h>

namespace NTravel::NGeoCounter {
    class TPromoServiceClient {
    public:
        explicit TPromoServiceClient(const NTravelProto::NAppConfig::TConfigGrpcClient& promoServiceClientConfig);
        ~TPromoServiceClient();

        void RegisterCounters(NMonitor::TCounterSource& counters);

        void Start();
        void Stop();

        NTravelProto::NPromoService::TGetActivePromosRsp GetActivePromos(const NTravelProto::NPromoService::TGetActivePromosReq& req, const TString& logPrefix);
        NTravelProto::NPromoService::TGetActivePromosRsp GetActivePromos(TInstant now, const TString& logPrefix);

    private:
        struct TCounters : public NMonitor::TCounterSource {
            NMonitor::TDerivCounter NGrpcErrors;

            void QueryCounters(NMonitor::TCounterTable* ct) const override;
        };

        TCounters Counters_;

        NGrpc::TAsyncClient<NTravelProto::NPromoService::PromoServiceV1> PromoServiceClient_;
    };
}
