#pragma once

#include "data.h"

#include <travel/hotels/proto/app_config/yt_table_cache.pb.h>
#include <travel/hotels/geocounter/proto/geocounter_data.pb.h>
#include <travel/hotels/geocounter/proto/config.pb.h>

#include <travel/hotels/lib/cpp/ages/ages.h>
#include <travel/hotels/lib/cpp/mon/tools.h>
#include <travel/hotels/lib/cpp/yt/table_cache.h>
#include <travel/hotels/lib/cpp/yt/queue_reader.h>

namespace NTravel::NGeoCounter {
    struct TRegion {
        i64 TravelGeoId;
        TBoundingBox Bounds;
        TMaybe<TPosition> Center;
        TString Geometry;
    };

    class TRegionsService {
    public:
        explicit TRegionsService(const NTravelProto::NAppConfig::TYtTableCacheConfig& regionsTableConfig);

        void RegisterCounters(NMonitor::TCounterSource& source);
        void Start();
        void Stop();
        void SetOnReady(std::function<void(void)> handler);
        bool IsReady() const;

        TMaybe<TBoundingBox> GetRegionBboxByTravelGeoId(int geoId) const;

    private:
        struct TCounters: public NMonitor::TCounterSource {
            NMonitor::TCounter IsWaiting;
            NMonitor::TCounter IsReady;

            NMonitor::TCounter NRecords;
            NMonitor::TCounter NRecordBytes;

            void QueryCounters(NMonitor::TCounterTable* ct) const override;
        };

        typedef THashMap<TTravelGeoId, TRegion> TRegionByTravelGeoId;

        void InitRegionsTable();
        void OnReady();

        mutable TCounters Counters_;

        TYtTableCache<NTravelProto::NGeoCounter::TRegionRecord> RegionsTable_;

        TAtomicFlag IsStopping_;
        std::function<void(void)> OnReady_;

        TMutex RegionsByTravelGeoIdMutex_;
        TAtomicSharedPtr<TRegionByTravelGeoId> OldRegionsByTravelGeoId_;
        TAtomicSharedPtr<TRegionByTravelGeoId> RegionsByTravelGeoId_;
        TAtomicSharedPtr<TRegionByTravelGeoId> NewRegionsByTravelGeoId_;
    };
}
