#pragma once

#include <travel/hotels/lib/cpp/util/flag.h>
#include <travel/hotels/lib/cpp/data/data.h>

#include <util/system/mutex.h>


namespace NTravel::NGeoCounter {
    template <class K, class V>
    class TReloadableStorage {
    public:
        using TData = THashMap<K, V>;

        TReloadableStorage()
            : Data_(MakeAtomicShared<TData>())
            , NewData_(MakeAtomicShared<TData>())
        {
        }

        std::pair<typename TData::iterator, bool> UnlockedAddToNewData(const K& key, const V& value) {
            return NewData_->emplace(key, value);
        }

        TAtomicSharedPtr<TData> GetData() const {
            with_lock (Mutex_) {
                return Data_;
            }
        }

        void ResetNewData() {
            auto emptyNewData = MakeAtomicShared<TData>();
            with_lock (Mutex_) {
                swap(NewData_, emptyNewData); // swap under lock, to ensure that memory is released outside of lock
            }
        }

        void CommitNewData() {
            with_lock (Mutex_) {
                swap(NewData_, Data_);
            }
            Ready_.Set();
            ResetNewData();
        }

        bool IsReady() const {
            return Ready_;
        }

    private:
        TAtomicFlag Ready_;
        TMutex Mutex_;
        TAtomicSharedPtr<TData> Data_;
        TAtomicSharedPtr<TData> NewData_;
    };
}
