#pragma once

#include "index.h"
#include "filters_config_reader.h"
#include "offercache_client.h"
#include "hotel_search_service.h"
#include "promo_service_client.h"
#include "regions_service.h"
#include "boy_partner_provider.h"

#include <travel/hotels/geocounter/proto/config.pb.h>
#include <travel/hotels/geocounter/proto/geocounter_data.pb.h>
#include <travel/hotels/proto/data_config/partner.pb.h>
#include <travel/hotels/proto/geocounter_service/geocounter_service.grpc.pb.h>

#include <travel/hotels/lib/cpp/data/data.h>
#include <travel/hotels/lib/cpp/grpc/grpc_async_client.h>
#include <travel/hotels/lib/cpp/grpc/grpc_async_server.h>
#include <travel/hotels/lib/cpp/http/http_service.h>
#include <travel/hotels/lib/cpp/logging/common_logger.h>
#include <travel/hotels/lib/cpp/memusage/memusage.h>
#include <travel/hotels/lib/cpp/mon/page.h>
#include <travel/hotels/lib/cpp/tvm/tvm_service.h>
#include <travel/hotels/lib/cpp/yt/queue_reader.h>
#include <travel/hotels/lib/cpp/yt/lock.h>
#include <travel/hotels/lib/cpp/yt/queue_reader_with_confirmation.h>
#include <travel/hotels/lib/cpp/util/restart_detector.h>

#include <util/system/rwlock.h>

namespace NTravel::NGeoCounter {
    class TService {
    public:
        using TGrpcServer = NGrpc::TAsyncServer<NTravelProto::NGeoCounter::GeoCounterServiceV1::AsyncService>;

        explicit TService(const NTravelProto::NGeoCounter::TConfig& config);
        ~TService() = default;

        void Start();
        void Wait();
        void Stop();

    private:
        using TReqAnsLogger = TCommonLogger<TString>;

        struct TCounters: public NMonitor::TCounterSource {
            explicit TCounters(TService& service);

            mutable NMonitor::TCounter IsReady;

            TService& Service_;

            void QueryCounters(NMonitor::TCounterTable* ct) const override;
        };

        struct TCountersPerRequestType: public NMonitor::TCounterSource {
            NMonitor::TDerivCounter NBadRequests;
            NMonitor::TDerivCounter NUnexpectedErrors;

            void QueryCounters(NMonitor::TCounterTable* ct) const override;
        };

        void OnSetLogLevel(const NHttp::TRequest& httpReq, const NHttp::TOnResponse& responseCb);
        void OnPing(const NHttp::TRequest& httpReq, const NHttp::TOnResponse& responseCb);
        void OnReopenReqAnsLog(const NHttp::TRequest& httpReq, const NHttp::TOnResponse& responseCb);
        void OnShutdown(const NHttp::TRequest& httpReq, const NHttp::TOnResponse& responseCb);
        void OnGetPermalinkInfo(const NHttp::TRequest& httpReq, const NHttp::TOnResponse& responseCb);

        void OnGrpcGetCounts(const NTravelProto::NGeoCounter::TGetCountsRequest& req,
                             const NGrpc::TServerReqMetadata& srvMeta,
                             const TGrpcServer::TResponseCb<NTravelProto::NGeoCounter::TGetCountsResponse>& responseCb);
        void OnGrpcGetHotels(const NTravelProto::NGeoCounter::TGetHotelsRequest& req,
                             const NGrpc::TServerReqMetadata& srvMeta,
                             const TGrpcServer::TResponseCb<NTravelProto::NGeoCounter::TGetHotelsResponse>& responseCb);
        void OnGrpcPing(const NTravelProto::TPingRpcReq& req,
                        const NGrpc::TServerReqMetadata& srvMeta,
                        const TGrpcServer::TResponseCb<NTravelProto::TPingRpcRsp>& responseCb);

        bool IsReady() const;

        TAtomicSharedPtr<TCountersPerRequestType> GetCountersPerRequestType(const TString& requestType);

        const NTravelProto::NGeoCounter::TConfig Config_;
        TBoyPartnerProvider BoyPartnerProvider_;
        TFiltersConfigReader FiltersConfigReader_;
        NMonitor::TBasicPage CountersPage_;
        NMonitor::THttpService MonWebService_;
        NHttp::TServer Http_;
        TRestartDetector RestartDetector_;
        TAutoEvent StopEvent_;
        TStringEncoder StringEncoder_;
        TFilterRegistry FilterRegistry_;
        TUserSegmentsRegistry UserSegmentsRegistry_;
        TSortTypeRegistry SortTypeRegistry_;
        TIndex Index_;
        TGrpcServer GrpcServer_;
        TAtomicFlag IsShuttingDown_;
        TCounters Counters_;
        NMonitor::TCounterHypercube<TCountersPerRequestType> CountersPerRequestType_;
        TOfferCacheClient OfferCacheClient_;
        TPromoServiceClient PromoServiceClient_;
        TRegionsService RegionsService_;
        NTravel::NTvm::TTvmService TvmService_;
        TBigbClient BigbClient_;
        THotelSearchService HotelSearchService_;
        TReqAnsLogger ReqAnsLogger_;
        TMemUsageCounters MemUsageCounters_;

        TRWMutex BoYPartnerIdsLock_;
        std::shared_ptr<TVector<NTravelProto::EPartnerId>> BoYPartnerIds_;
    };
}
