#pragma once

#include "data.h"

#include <travel/hotels/geocounter/proto/config.pb.h>
#include <travel/hotels/proto/geocounter_service/geocounter_service.pb.h>

#include <catboost/libs/model/model.h>

#include <functional>

namespace NTravel::NGeoCounter {
    class TCatBoostModelEvaluator {
     public:
        TCatBoostModelEvaluator(const NTravelProto::NGeoCounter::TConfig::TCatBoostModel& config,
                                TStringEncoder& stringEncoder,
                                const TUserSegmentsRegistry& userSegmentsRegistry);

        void ReorderTopHotels(TVector<THotelsResults::THotelResult>* hotels, const TCryptaSegments& cryptaSegments, bool applySort) const;
     private:
        NTravelProto::NGeoCounter::TConfig::TCatBoostModel Config_;
        TFullModel Model_;
        TVector<std::function<float(const THashMap<int, float>&, const TCryptaSegments&)>> FloatFeatureGetters_;
        TVector<std::function<ui32(const THashMap<int, ui32>&, const TCryptaSegments&, const THashMap<int, TVector<ui32>>&)>> CatFeatureGetters_;
    };


    class TSortType {
    public:
        struct TSortContext {
            TSortContext(const TCryptaSegments& userCryptaSegments, TMaybe<TPosition> SortOrigin);

            const TCryptaSegments& UserCryptaSegments;
            TMaybe<TPosition> SortOrigin;
        };

        typedef std::function<bool(const THotelSortData&, const THotelSortData&)> SortInIndexCmpFunc;
        typedef std::function<bool(const THotelsResults::THotelResult&, const THotelsResults::THotelResult&)> SortBeforeRespCmpFunc;
        typedef std::function<void(TVector<THotelsResults::THotelResult>*, const TSortContext&)> TReorderFunc;

        struct TReorderTopRecordsParams {
            size_t TopSize;
            TReorderFunc ReorderFunc;
        };

        struct TRealTimeSortInIndex {
            std::function<i64(const TFilteringPermalinkInfo&, const TSortContext&)> GetFactorFunc;
            std::function<void(TVector<THotelsResults::THotelResult>*, const THashMap<TPermalink, i64>&)> ReorderFunc;
        };

        size_t Id;
        NTravelProto::NGeoCounter::ESortType SortType;
        int Priority;
        THashMap<int, TVector<int>> CryptaSegmentFilters;

        TSortType(size_t id,
                  NTravelProto::NGeoCounter::ESortType sortType,
                  int priority,
                  const THashMap<int, TVector<int>>& cryptaSegmentFilters,
                  SortInIndexCmpFunc cmpSortInIndex,
                  TMaybe<SortBeforeRespCmpFunc> cmpSortBeforeResp = {},
                  TMaybe<TReorderTopRecordsParams> reorderTopRecordsParams = {},
                  TMaybe<TRealTimeSortInIndex> realTimeSortInIndex = {});

        TString GetStringRepr() const;
        bool MatchesSegments(const TCryptaSegments& userCryptaSegments) const;
        const SortInIndexCmpFunc& GetCmpSortInIndex() const;
        const TMaybe<TSortType::SortBeforeRespCmpFunc>& GetCmpSortBeforeResp() const;
        const TMaybe<TReorderTopRecordsParams>& GetReorderTopRecordsParams() const;
        const TMaybe<TRealTimeSortInIndex>& GetRealTimeSortInIndex() const;
    private:
        SortInIndexCmpFunc SortInIndexCmp;
        TMaybe<SortBeforeRespCmpFunc> SortBeforeRespCmp;
        TMaybe<TReorderTopRecordsParams> ReorderTopRecordsParams;
        TMaybe<TRealTimeSortInIndex> RealTimeSortInIndex;
    };

    struct TSortTypeWithContext {
        TSortTypeWithContext(const TSortType& sortType, TSortType::TSortContext context);

        const TSortType& SortType;
        TSortType::TSortContext Context;
    };

    class TSortTypeRegistry {
    public:
        TSortType GetDefaultSortType() const;
        TVector<TSortType> GetSortTypes() const;
        TSortType GetSortType(NTravelProto::NGeoCounter::ESortType sortTypeEnum, const TCryptaSegments& userCryptaSegments) const;

        static TSortTypeRegistry Build(TStringEncoder& stringEncoder,
                                       const NTravelProto::NGeoCounter::TConfig& config,
                                       const TUserSegmentsRegistry& userSegmentsRegistry);

    private:
        TSortTypeRegistry(const TVector<TSortType>& sortTypes, size_t defaultSortTypeIndex);

        TVector<TSortType> SortTypes;
        size_t DefaultSortTypeIndex;
    };
}
