#include "string_encoder.h"

#include <library/cpp/logger/global/global.h>

namespace NTravel::NGeoCounter {
    int TStringEncoder::Encode(const TString& value) {
        {
            TReadGuard g(Mutex_);
            if (Mapping_.contains(value)) {
                return Mapping_[value];
            }
        }
        TWriteGuard g(Mutex_);
        if (!Mapping_.contains(value)) {
            Counters_.NRecords.Inc();
            Counters_.NBytesApproximately += sizeof(TString) + value.length() +
                                             sizeof(decltype(Mapping_)::value_type) + sizeof(decltype(Mapping_)::key_type);
            Mapping_.emplace(value, ReverseMapping_.size());
            ReverseMapping_.push_back(value);
        }
        return Mapping_[value];
    }

    TString TStringEncoder::Decode(int value) const {
        TReadGuard g(Mutex_);
        if (value < 0 || static_cast<size_t>(value) >= ReverseMapping_.size()) {
            ythrow yexception() << "Tried to decode unknown value";
        }
        return ReverseMapping_[value];
    }

    void TStringEncoder::RegisterCounters(NMonitor::TCounterSource& source) {
        source.RegisterSource(&Counters_, "StringEncoder");
    }

    void TStringEncoder::TCounters::QueryCounters(NMonitor::TCounterTable* ct) const {
        ct->insert(MAKE_COUNTER_PAIR(NRecords));
        ct->insert(MAKE_COUNTER_PAIR(NBytesApproximately));
    }
}
