#pragma once

#include <travel/hotels/lib/cpp/mon/tools.h>

#include <util/generic/string.h>
#include <util/generic/hash.h>
#include <util/generic/vector.h>
#include <util/system/rwlock.h>

namespace NTravel::NGeoCounter {
    class TStringEncoder {
    public:
        int Encode(const TString& value);
        TString Decode(int value) const;
        void RegisterCounters(NMonitor::TCounterSource& source);

    private:
        struct TCounters: public NMonitor::TCounterSource {
            NMonitor::TCounter NRecords;
            NMonitor::TCounter NBytesApproximately;

            void QueryCounters(NMonitor::TCounterTable* ct) const override;
        };

        TCounters Counters_;

        TRWMutex Mutex_;
        THashMap<TString, int> Mapping_;
        TVector<TString> ReverseMapping_;
    };
}
