#include "utils.h"

namespace NTravel::NGeoCounter {
    TMaybe<double> GetRating(const THashMap<int, TFeature>& features, int ratingFeatureId) {
        auto ratingIt = features.find(ratingFeatureId);
        if (ratingIt != features.end()) {
            Y_ENSURE(std::holds_alternative<double>(ratingIt->second.Value), "rating feature should have single value");
            return std::get<double>(ratingIt->second.Value);
        }
        return {};
    }
}