LIBRARY()

OWNER(g:travel-hotels)

SRCS(
    additional_filter.cpp
    boy_partner_provider.cpp
    bigb_client.cpp
    data.cpp
    coordinate_utils.cpp
    features_filtering.cpp
    filter_registry.cpp
    filters_config_reader.cpp
    hotel_search_service.cpp
    index.cpp
    offercache_client.cpp
    promo_service_client.cpp
    regions_service.cpp
    reloadable_storage.cpp
    service.cpp
    sorts.cpp
    string_encoder.cpp
    utils.cpp
)

RESOURCE(
    travel/hotels/devops/resources/portal-search-filters.pb.txt portal-search-filters.pb.txt
)

PEERDIR(
    travel/hotels/geocounter/proto
    travel/hotels/lib/cpp/data
    travel/hotels/lib/cpp/grpc
    travel/hotels/lib/cpp/http
    travel/hotels/lib/cpp/logging
    travel/hotels/lib/cpp/memusage
    travel/hotels/lib/cpp/mon
    travel/hotels/lib/cpp/permalink_mappers/mappers
    travel/hotels/lib/cpp/protobuf
    travel/hotels/lib/cpp/scheduler
    travel/hotels/lib/cpp/yt
    travel/hotels/lib/cpp/util
    travel/hotels/proto/geocounter_service
    travel/hotels/proto/hotel_filters_config
    travel/hotels/proto/data_config
    travel/hotels/proto/offercache_grpc
    travel/hotels/proto/promo_service
    travel/hotels/proto/offerbus_messages
    travel/hotels/proto2
    catboost/libs/cat_feature
    catboost/libs/model
    library/cpp/resource
    contrib/libs/grpc/grpc++_reflection
    library/cpp/neh
    library/cpp/tvmauth/client
    library/cpp/blockcodecs
    yabs/proto
)

GENERATE_ENUM_SERIALIZATION(additional_filter.h)


END()
