package ru.yandex.travel.hotels.administrator;

import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Import;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;

import ru.yandex.travel.workflow.WorkflowConfiguration;
import ru.yandex.travel.workflow.repository.WorkflowRepositoryConfiguration;

@SpringBootApplication
@EnableJpaRepositories(
        basePackages = {"ru.yandex.travel.hotels.administrator", "ru.yandex.travel.workflow"},
        enableDefaultTransactions = false
)
@Import({
        WorkflowConfiguration.class,
        // we need this configuration to be enabled everywhere, including all @DataJpaTest-s
        WorkflowRepositoryConfiguration.class
})
@Slf4j
public class AdministratorApplication {

    public static void main(String[] args) {
        SpringApplication.run(AdministratorApplication.class, args);
    }
}
