package ru.yandex.travel.hotels.administrator;

import io.grpc.stub.StreamObserver;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.commons.grpc.ServerUtils;
import ru.yandex.travel.grpc.GrpcService;
import ru.yandex.travel.orders.proto.EServerState;
import ru.yandex.travel.orders.proto.HADiscoveryInterfaceV1Grpc.HADiscoveryInterfaceV1ImplBase;
import ru.yandex.travel.orders.proto.TPingRpcReq;
import ru.yandex.travel.orders.proto.TPingRpcRsp;
import ru.yandex.travel.workflow.ha.MasterAwareResourceManager;

@GrpcService(authenticateService = true, trace = false)
@RequiredArgsConstructor
@Slf4j
public class HADiscoveryService extends HADiscoveryInterfaceV1ImplBase {

    private final MasterAwareResourceManager masterAwareResourceManager;

    @Override
    public void ping(TPingRpcReq request, StreamObserver<TPingRpcRsp> responseObserver) {
        ServerUtils.synchronously(log, request, responseObserver,
                req -> TPingRpcRsp.newBuilder()
                        .setState(masterAwareResourceManager.isMaster() ? EServerState.SS_MASTER :
                                EServerState.SS_STANDBY)
                        .build());
    }
}
