package ru.yandex.travel.hotels.administrator.cache;

import java.util.Collection;
import java.util.function.Function;

import lombok.EqualsAndHashCode;
import lombok.RequiredArgsConstructor;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;

import ru.yandex.travel.hotels.administrator.cache.proto.TAltayPublishingRecord;
import ru.yandex.travel.yt_lucene_index.MultiMapPersistentConfig;
import ru.yandex.travel.yt_lucene_index.YtLuceneIndexParams;

public class AltayPublishingDictionary extends MultiMapPersistentConfig<AltayPublishingDictionary.Key, TAltayPublishingRecord, TAltayPublishingRecord> implements HealthIndicator {

    public static final String ALTAY_PUBLISHING = "altay_publishing";

    public AltayPublishingDictionary(YtLuceneIndexParams params) {
        super(params, ALTAY_PUBLISHING, TAltayPublishingRecord::newBuilder, record -> new Key(record.getProviderId(),
                record.getOriginalId()), Function.identity(), Function.identity());
    }

    public Collection<TAltayPublishingRecord> getRecords(Long providerId, String originalId) {
        return getByKey(new Key(providerId, originalId));
    }

    @Override
    public Health health() {
        if (isReady()) {
            return Health.up().build();
        } else {
            return Health.down().build();
        }
    }

    @RequiredArgsConstructor
    @EqualsAndHashCode
    public static class Key {
        private final Long providerId;

        private final String originalId;
    }
}
