package ru.yandex.travel.hotels.administrator.cache;

import java.util.function.Function;

import lombok.EqualsAndHashCode;
import lombok.RequiredArgsConstructor;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;

import ru.yandex.travel.hotels.administrator.cache.proto.TAltaySignalRecord;
import ru.yandex.travel.yt_lucene_index.MapPersistentConfig;
import ru.yandex.travel.yt_lucene_index.YtLuceneIndexParams;

public class AltaySignalsDictionary extends MapPersistentConfig<AltaySignalsDictionary.Key, TAltaySignalRecord, TAltaySignalRecord> implements HealthIndicator {

    public static final String ALTAY_SIGNALS = "altay_signals";

    public AltaySignalsDictionary(YtLuceneIndexParams params) {
        super(params, ALTAY_SIGNALS, TAltaySignalRecord::newBuilder, record -> new Key(record.getProviderId(),
                record.getOriginalId()), Function.identity());
    }

    public TAltaySignalRecord getRecord(Long providerId, String originalId) {
        return getByKey(new Key(providerId, originalId));
    }

    @Override
    public Health health() {
        if (isReady()) {
            return Health.up().build();
        } else {
            return Health.down().build();
        }
    }

    @RequiredArgsConstructor
    @EqualsAndHashCode
    public static class Key {
        private final Long providerId;

        private final String originalId;
    }
}
