package ru.yandex.travel.hotels.administrator.cache;

import java.util.function.Function;

import lombok.EqualsAndHashCode;
import lombok.RequiredArgsConstructor;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;

import ru.yandex.travel.hotels.administrator.cache.proto.THotelClustering;
import ru.yandex.travel.hotels.proto.EPartnerId;
import ru.yandex.travel.yt_lucene_index.MapPersistentConfig;
import ru.yandex.travel.yt_lucene_index.YtLuceneIndexParams;

public class HotelClusteringDictionary extends MapPersistentConfig<
        HotelClusteringDictionary.ClusteringKey,
        THotelClustering,
        THotelClustering> implements HealthIndicator {

    public static final String HOTELS_CLUSTERING = "hotels_clustering";

    public HotelClusteringDictionary(YtLuceneIndexParams params) {
        super(
                params,
                HOTELS_CLUSTERING,
                THotelClustering::newBuilder,
                hotelClustering -> new ClusteringKey(
                        hotelClustering.getPartnerId(),
                        hotelClustering.getHotelCode()
                ),
                Function.identity());
    }

    public boolean isHotelClusteringVerified(EPartnerId partnerId, String hotelCode) {
        THotelClustering hotelClustering = getByKey(new ClusteringKey(partnerId, hotelCode));
        return hotelClustering != null;
    }

    @Override
    public Health health() {
        if (isReady()) {
            return Health.up().build();
        } else {
            return Health.down().build();
        }
    }

    @RequiredArgsConstructor
    @EqualsAndHashCode
    public static class ClusteringKey {

        private final EPartnerId partnerId;

        private final String hotelCode;

    }

}
