package ru.yandex.travel.hotels.administrator.cache;

import java.util.function.Function;

import lombok.EqualsAndHashCode;
import lombok.RequiredArgsConstructor;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;

import ru.yandex.travel.hotels.administrator.cache.proto.THotelFeedRecord;
import ru.yandex.travel.hotels.proto.EPartnerId;
import ru.yandex.travel.yt_lucene_index.MapPersistentConfig;
import ru.yandex.travel.yt_lucene_index.YtLuceneIndexParams;

public class HotelFeedsDictionary extends MapPersistentConfig<HotelFeedsDictionary.Key, THotelFeedRecord, THotelFeedRecord> implements HealthIndicator {

    public static final String HOTEL_FEEDS = "hotel_feeds";

    public HotelFeedsDictionary(YtLuceneIndexParams params) {
        super(params, HOTEL_FEEDS, THotelFeedRecord::newBuilder, record -> new Key(record.getPartnerId(),
                record.getOriginalId()), Function.identity());
    }

    public boolean hasRecord(EPartnerId partnerId, String hotelCode) {
        return getByKey(new Key(partnerId, hotelCode)) != null;
    }

    @Override
    public Health health() {
        if (isReady()) {
            return Health.up().build();
        } else {
            return Health.down().build();
        }
    }

    @RequiredArgsConstructor
    @EqualsAndHashCode
    public static class Key {
        private final EPartnerId partnerId;

        private final String originalId;
    }
}
