package ru.yandex.travel.hotels.administrator.configuration;

import io.opentracing.Tracer;
import lombok.RequiredArgsConstructor;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.Dsl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.commons.logging.AsyncHttpClientWrapper;
import ru.yandex.travel.hotels.administrator.service.AddressUnificationService;

@Configuration
@EnableConfigurationProperties(AddressUnifierProperties.class)
@RequiredArgsConstructor
public class AddressUnifierConfiguration {

    private static Logger DEFAULT_HTTP_LOGGER = LoggerFactory.getLogger("ru.yandex.travel.hotels.administrator.HttpLogger");

    private final AddressUnifierProperties addressUnifierProperties;

    private final Tracer tracer;

    @Bean
    public AsyncHttpClient addressUnifierAsyncClient() {
        return Dsl.asyncHttpClient(Dsl.config()
                .setThreadPoolName("ADDRESS_UNIFIER_POOL")
                .build());
    }

    @Bean
    public AsyncHttpClientWrapper addressUnifierAhcWrapper() {
        return new AsyncHttpClientWrapper(addressUnifierAsyncClient(), DEFAULT_HTTP_LOGGER, "address-unifier", tracer);
    }

    @Bean
    public AddressUnificationService addressUnificationService() {
        return new AddressUnificationService(addressUnifierAhcWrapper(), addressUnifierProperties.getBaseUrl());
    }
}
