package ru.yandex.travel.hotels.administrator.configuration;

import io.opentracing.Tracer;
import lombok.RequiredArgsConstructor;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.validation.annotation.Validated;

import ru.yandex.travel.commons.logging.AsyncHttpClientWrapper;
import ru.yandex.travel.integration.balance.BillingApiClient;
import ru.yandex.travel.integration.balance.BillingApiProperties;
import ru.yandex.travel.tvm.TvmWrapper;

@ConditionalOnProperty("billing-api.enabled")
@Configuration
@RequiredArgsConstructor
public class BillingApiConfiguration {

    private static Logger DEFAULT_HTTP_LOGGER = LoggerFactory.getLogger(
            "ru.yandex.travel.hotels.administrator.HttpLogger");

    private final Tracer tracer;

    @ConfigurationProperties(value = "billing-api", ignoreUnknownFields = false)
    @Bean
    @Validated
    public BillingApiProperties billingApiProperties() {
        return new BillingApiProperties();
    }

    @Bean
    public DefaultAsyncHttpClientConfig.Builder billingApiAhcConfig() {
        return Dsl.config().setThreadPoolName("billingApiAhc");
    }

    @Bean
    public AsyncHttpClient billingApiAhc() {
        return Dsl.asyncHttpClient(billingApiAhcConfig().build());
    }

    @Bean
    public AsyncHttpClientWrapper billingApiAhcWrapper() {
        return new AsyncHttpClientWrapper(billingApiAhc(), DEFAULT_HTTP_LOGGER, "billing-api", tracer, null);
    }

    @Bean
    public BillingApiClient billingApiClient(@Autowired(required = false) TvmWrapper tvm) {
        return new BillingApiClient(billingApiAhcWrapper(), billingApiProperties(), tvm);
    }
}
