package ru.yandex.travel.hotels.administrator.configuration;

import java.util.UUID;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.hotels.administrator.repository.LegalDetailsRepository;
import ru.yandex.travel.hotels.administrator.service.Meters;
import ru.yandex.travel.hotels.administrator.task.BillingContractFlagsSynchronizer;
import ru.yandex.travel.integration.balance.BillingApiClient;
import ru.yandex.travel.spring.tx.ForcedRollbackTxManagerWrapper;
import ru.yandex.travel.task_processor.TaskKeyProvider;
import ru.yandex.travel.task_processor.TaskProcessor;
import ru.yandex.travel.task_processor.TaskProcessorHelper;
import ru.yandex.travel.utils.ClockService;

@Configuration
@RequiredArgsConstructor
@EnableConfigurationProperties({BillingContractFlagsSynchronizerProperties.class})
public class BillingContractFlagsSynchronizerConfiguration {

    private final BillingContractFlagsSynchronizerProperties properties;
    private final LegalDetailsRepository legalDetailsRepository;
    private final ForcedRollbackTxManagerWrapper forcedRollbackTxManagerWrapper;
    private final BillingApiClient billingApiClient;
    private final ClockService clockService;
    private final Meters meters;


    @Bean
    public BillingContractFlagsSynchronizer billingContractFlagsSynchronizer() {
        return new BillingContractFlagsSynchronizer(properties, legalDetailsRepository, billingApiClient,
                clockService, meters);
    }

    @Bean
    @Autowired
    @ConditionalOnProperty(value = "billing-flags-synchronizer.task-processor.enabled", havingValue = "true")
    public TaskProcessor<UUID> billingContractFlagsSynchronizerTaskProcessor(
            BillingContractFlagsSynchronizer billingContractFlagsSynchronizer) {
        TaskKeyProvider<UUID> taskKeyProvider = TaskProcessorHelper.createTaskKeyProvider(
                billingContractFlagsSynchronizer::getReadyTasks,
                billingContractFlagsSynchronizer::countPendingTasks
        );
        return new TaskProcessor<>(
                taskKeyProvider,
                billingContractFlagsSynchronizer::processTask,
                forcedRollbackTxManagerWrapper,
                TaskProcessorHelper.createDefaultTxDefinition("BillingFlagsSyncTxDefinition"),
                properties.getTaskProcessor());
    }
}
