package ru.yandex.travel.hotels.administrator.configuration;

import java.time.Duration;

import javax.validation.constraints.NotNull;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

import ru.yandex.travel.task_processor.TaskProcessorProperties;

@Getter
@Setter
@ConfigurationProperties(value = "billing-flags-synchronizer", ignoreUnknownFields = false)
@Validated
public class BillingContractFlagsSynchronizerProperties {
    @NotNull
    private Duration synchronizationInterval;

    @NotNull
    private TaskProcessorProperties taskProcessor;
}
