package ru.yandex.travel.hotels.administrator.configuration;

import java.time.ZoneOffset;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Positive;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;
import org.springframework.validation.annotation.Validated;

@Component
@ConfigurationProperties(value = "billing-service", ignoreUnknownFields = false)
@Validated
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class BillingServiceProperties {
    @NotNull
    @Positive
    public Integer serviceId;
    @NotNull
    @Positive
    public Long operatorId;
    @NotNull
    @Positive
    public Long managerId;
    @NotNull
    @Positive
    public Integer paymentTermInDays;
    @NotNull
    public ZoneOffset billingZoneOffset;
}
