package ru.yandex.travel.hotels.administrator.configuration;

import lombok.RequiredArgsConstructor;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.hotels.administrator.service.ClusterizationService;

@Configuration
@RequiredArgsConstructor
@EnableConfigurationProperties({ClusterizationProperties.class, YtConnectionProperties.class})
public class ClusterizationServiceConfiguration {
    private final ClusterizationProperties serviceProperties;
    private final YtConnectionProperties connectionProperties;

    @Bean
    public ClusterizationService clusterizationService() {
        return new ClusterizationService(serviceProperties, connectionProperties);
    }
}
