package ru.yandex.travel.hotels.administrator.configuration;

import lombok.RequiredArgsConstructor;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import ru.yandex.travel.hotels.administrator.service.SupervisorService;

@Component
@RequiredArgsConstructor
public class ContextRefreshedListener implements ApplicationListener<ContextRefreshedEvent> {

    private final SupervisorService supervisorService;

    @Override
    @Transactional
    public void onApplicationEvent(ContextRefreshedEvent event) {
        supervisorService.ensureSupervisorsExist();
    }
}
