package ru.yandex.travel.hotels.administrator.configuration;

import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.flyway.FlywayMigrationStrategy;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
@Slf4j
public class CustomFlywayConfiguration {
    @Bean
    @Profile("prod")
    public FlywayMigrationStrategy prodFlywayMigrationStrategy() {
        return flyway -> log.info("Skipping auto migrations. Be careful to run them manually");
    }

    @Bean
    @Profile("testing")
    public FlywayMigrationStrategy testingFlywayMigrationStrategy() {
        return flyway -> { flyway.migrate(); };
    }
}
