package ru.yandex.travel.hotels.administrator.configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.opentracing.Tracer;
import lombok.RequiredArgsConstructor;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.Dsl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.commons.logging.AsyncHttpClientWrapper;
import ru.yandex.travel.commons.retry.Retry;
import ru.yandex.travel.hotels.geosearch.GeoSearchProperties;
import ru.yandex.travel.hotels.geosearch.GeoSearchService;
import ru.yandex.travel.tvm.TvmWrapper;

@Configuration
@EnableConfigurationProperties(GeoSearchProperties.class)
@RequiredArgsConstructor
public class GeoSearchConfiguration {

    private static Logger DEFAULT_HTTP_LOGGER = LoggerFactory.getLogger("ru.yandex.travel.hotels.administrator.HttpLogger");

    private final GeoSearchProperties geoSearchProperties;

    private final ObjectMapper objectMapper;

    private final Tracer tracer;

    private final Retry retryHelper;

    @Bean
    public AsyncHttpClient geoSearchAsyncClient() {
        return Dsl.asyncHttpClient(Dsl.config()
                .setThreadPoolName("GEO_SEARCH_POOL")
                .build());
    }

    @Bean
    public AsyncHttpClientWrapper geoSearchAhcWrapper() {
        return new AsyncHttpClientWrapper(geoSearchAsyncClient(), DEFAULT_HTTP_LOGGER, "geosearch", tracer);
    }

    @Bean
    public GeoSearchService geoSearchService(@Autowired(required = false) TvmWrapper tvm) {
        return new GeoSearchService(geoSearchProperties, geoSearchAhcWrapper(), objectMapper, tvm, retryHelper);
    }
}
