package ru.yandex.travel.hotels.administrator.configuration;

import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.List;

import javax.validation.constraints.NotNull;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(value = "hotel-connection", ignoreUnknownFields = false)
@Getter
@Setter
@Validated
public class HotelConnectionProperties {

    private List<CommissionSchema> commissions;

    private boolean createAgreements;

    private boolean allowCheckRuBankAccountCall;

    private Duration geoSearchCallRetryDelay = Duration.ofHours(4);

    @Getter
    @Setter
    public static class CommissionSchema {

        @NotNull
        private int priority;

        @NotNull
        private BigDecimal confirmedRate;

        @NotNull
        private BigDecimal refundedRate;

        @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
        private LocalDateTime startDate;

        @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
        private LocalDateTime endDate;

    }
}
