package ru.yandex.travel.hotels.administrator.configuration;

import java.util.Map;
import java.util.Set;

import javax.persistence.EntityManager;

import com.google.common.collect.ImmutableMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.bolts.collection.Option;
import ru.yandex.travel.hotels.administrator.entity.BillingRegistration;
import ru.yandex.travel.hotels.administrator.entity.CallGeoSearchStep;
import ru.yandex.travel.hotels.administrator.entity.HotelConnection;
import ru.yandex.travel.hotels.administrator.entity.HotelConnectionUpdate;
import ru.yandex.travel.hotels.administrator.entity.LegalDetails;
import ru.yandex.travel.hotels.administrator.entity.RegisterInBalanceStep;
import ru.yandex.travel.hotels.administrator.entity.Ticket;
import ru.yandex.travel.hotels.administrator.entity.UpdateBalanceDataStep;
import ru.yandex.travel.hotels.administrator.entity.VerifyClusteringStep;
import ru.yandex.travel.hotels.administrator.entity.WorkflowEntityType;
import ru.yandex.travel.workflow.BasicMessagingContext;
import ru.yandex.travel.workflow.MessagingContextFactory;

@Configuration
public class MessagingContextFactoryConfiguration {

    @Autowired
    private EntityManager em;

    @Bean
    public MessagingContextFactory messagingContextFactory() {
        Map<String, Class<?>> workflowEntityClasses = ImmutableMap.<String, Class<?>>builder()
                .put(WorkflowEntityType.HOTEL_CONNECTION.getDiscriminatorValue(), HotelConnection.class)
                .put(WorkflowEntityType.HOTEL_CONNECTION_UPDATE.getDiscriminatorValue(), HotelConnectionUpdate.class)
                .put(WorkflowEntityType.LEGAL_DETAILS.getDiscriminatorValue(), LegalDetails.class)
                .put(WorkflowEntityType.REGISTER_IN_BALANCE_STEP.getDiscriminatorValue(), RegisterInBalanceStep.class)
                .put(WorkflowEntityType.VERIFY_CLUSTERING_STEP.getDiscriminatorValue(), VerifyClusteringStep.class)
                .put(WorkflowEntityType.CALL_GEOSEARCH_STEP.getDiscriminatorValue(), CallGeoSearchStep.class)
                .put(WorkflowEntityType.UPDATE_BALANCE_DATA_STEP.getDiscriminatorValue(), UpdateBalanceDataStep.class)
                .put(WorkflowEntityType.BILLING_REGISTRATION.getDiscriminatorValue(), BillingRegistration.class)
                .put(WorkflowEntityType.TICKET.getDiscriminatorValue(), Ticket.class)
                .build();
        Set<String> withoutRepository = Set.of(
                WorkflowEntityType.GENERIC_SUPERVISOR.getDiscriminatorValue()
        );


        return (workflow, attempt) -> {
            if (withoutRepository.contains(workflow.getEntityType())) {
                return Option.of(new BasicMessagingContext<>(workflow.getId(), null, attempt, workflow.getWorkflowVersion()));
            } else {
                Class<?> entityClass = workflowEntityClasses.get(workflow.getEntityType());
                if (entityClass == null) {
                    return Option.empty();
                }
                return Option.of(new BasicMessagingContext<>(workflow.getId(),
                        em.getReference(entityClass, workflow.getEntityId()), attempt, workflow.getWorkflowVersion()));
            }
        };
    }

}
