package ru.yandex.travel.hotels.administrator.configuration;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.hotels.administrator.cache.HotelClusteringDictionary;
import ru.yandex.travel.hotels.administrator.repository.HotelConnectionRepository;
import ru.yandex.travel.hotels.administrator.service.StarTrekService;
import ru.yandex.travel.hotels.administrator.task.PermalinkUpdateTask;
import ru.yandex.travel.spring.tx.ForcedRollbackTxManagerWrapper;
import ru.yandex.travel.task_processor.TaskProcessor;
import ru.yandex.travel.task_processor.TaskProcessorHelper;

@Configuration
@RequiredArgsConstructor
@EnableConfigurationProperties(PermalinkUpdateTaskProperties.class)
public class PermalinkUpdateTaskConfiguration {

    private final PermalinkUpdateTaskProperties permalinkUpdateTaskProperties;
    private final HotelConnectionRepository hotelConnectionRepository;
    private final HotelClusteringDictionary hotelClusteringDictionary;
    private final ForcedRollbackTxManagerWrapper forcedRollbackTxManagerWrapper;
    private final StarTrekService starTrekService;

    @Bean
    public PermalinkUpdateTask permalinkUpdateTask() {
        return new PermalinkUpdateTask(hotelConnectionRepository, hotelClusteringDictionary, starTrekService);
    }

    @Bean
    @Autowired
    @ConditionalOnProperty("permalink-update-task.task-processor.enabled")
    public TaskProcessor<String> permalinkUpdateTaskProcessor(PermalinkUpdateTask permalinkUpdateTask) {
        return new TaskProcessor<>(
                permalinkUpdateTask,
                permalinkUpdateTask::updatePermalinks,
                forcedRollbackTxManagerWrapper,
                TaskProcessorHelper.createDefaultTxDefinition("permalinkUpdateTaskTxDefinition"),
                permalinkUpdateTaskProperties.getTaskProcessor());
    }
}
