package ru.yandex.travel.hotels.administrator.configuration;

import io.opentracing.Tracer;
import lombok.RequiredArgsConstructor;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.Dsl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.validation.annotation.Validated;

import ru.yandex.travel.commons.logging.AsyncHttpClientWrapper;
import ru.yandex.travel.integration.spark.SparkClient;
import ru.yandex.travel.integration.spark.SparkClientProperties;

@Configuration
@RequiredArgsConstructor
public class SparkApiConfiguration {

    private static Logger DEFAULT_HTTP_LOGGER = LoggerFactory.getLogger(
            "ru.yandex.travel.hotels.administrator.HttpLogger");

    private final Tracer tracer;

    @ConfigurationProperties(value = "spark-api", ignoreUnknownFields = false)
    @Bean
    @Validated
    public SparkClientProperties sparkClientProperties() {
        return new SparkClientProperties();
    }

    @Bean
    public AsyncHttpClient sparkApiAhc() {
        return Dsl.asyncHttpClient(Dsl.config()
                .setThreadPoolName("SPARK_API_POOL")
                .build());
    }

    @Bean
    public AsyncHttpClientWrapper sparkApiAhcWrapper() {
        return new AsyncHttpClientWrapper(sparkApiAhc(), DEFAULT_HTTP_LOGGER, "spark-api", tracer, null);
    }

    @Bean
    public SparkClient sparkClient() {
        return new SparkClient(sparkApiAhcWrapper(), sparkClientProperties());
    }
}
