package ru.yandex.travel.hotels.administrator.configuration;

import java.time.Duration;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Positive;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(value = "st", ignoreUnknownFields = false)
@Getter
@Setter
@Validated
public class StarTrekConfigurationProperties {
    @NotEmpty
    private String url;
    @NotEmpty
    private String oauthToken;
    private Duration connectionTimeout = Duration.ofSeconds(1);
    private Duration socketTimeout = Duration.ofSeconds(15);
    @Positive
    private int maxConnections;
    @NotEmpty
    private String queueName;

    private String workflowCrashedTicketTitle = "Упал workflow для сущности %s, workflowId: %s";
    private String hotelConnectionTicketTitle = "Подключение отеля \"%s\" (original_id: %s, партнер: %s, permalink: %d)";
    private String legalDetailsTicketTitle = "Заведение юр. лица %s (ИНН: %s)";
    private String verifyClusteringTicketTitle = "Проверить кластеризацию отеля \"%s\" (original_id: %s, партнер: %s, permalink: %d)";
    private String verifyClusteringTicketDescription = "Нужно удостовериться, что отель правильно кластеризовался, иначе брони пойдут не в тот отель.";
    private String manualVerificationTicketTitle = "Поменялись реквизиты у отеля \"%s\" (original_id: %s, партнер: %s, permalink: %d)";
    private String commentRegisteredInBalance = "Контрагент зарегистрирован в балансе. ClientId: %s, ContractId: %s";
    private String commentLegalDetailsRegistered = "Юр. лицо зарегистрировано!";
    private String commentClusteringStarted = "Проверка кластеризации запущена автоматически";
    private String commentClusteringVerified = "Проверка кластеризации завершена";
    private String commentPermalinkChanged = "Пермалинк изменился на";
    private String commentLegalDetailsReady = "Реквизиты отеля зарегистрированы";
    private String commentHotelGetsPublished = "Отель опубликован!";
    private String hotelIsMissingInGSTicketTitle = "Дождаться, пока отель прорастет до Геопоиска (original_id: %s, партнер: %s)";
    private String hotelIsMissingInGSTicketDescription = "В момент вызова к Геопоиску отеля не оказалось.\nКогда отель прорастет, можно закрыть тикет.\nЕсли после закрытия тикета отеля по-прежнему нет в ГП, то тикет будет переоткрыт.";
    private String commentGSCallFailed = "Вызов к Геопоиску закончился ошибкой:\n\n%s";
    private String commentHotelAppearedInGS = "Отель появился в Геопоиске";
    private String commentConnectionUpdateProcessing = "Обновление реквизитов в процессе";
    private String hotelConnectionUpdateRejected = "Обновление реквизитов отклонено";
    private String commentLegalDetailsHaveBeenPublished = "Обновление реквизитов в Балансе завершено";
    private String commentFinancialEventsUpdated = "Фин события обновлены";
    private String hotelConnectionUpdateFinished = "Обновление реквизитов завершено. Отель теперь привязан к ClientId=%d";
    private String commentCantAcceptWrongBikAndAccount = "Тикет с ошибочными БИК или рассчетным счётом можно только отклонять";
    private String commentCantProcessHotelConnectionTwice = "Нельзя несколько раз обработать тикет (отклонить/принять). Нужно призвать дежурного, если что-то пошло не так.";

    private String hotelConnectionUpdateAutoProcessingWaitTag = "waiting_for_auto_processing";
}
