package ru.yandex.travel.hotels.administrator.configuration;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.hotels.administrator.repository.HotelConnectionRepository;
import ru.yandex.travel.hotels.administrator.service.partners.TravellineService;
import ru.yandex.travel.hotels.administrator.task.TravellineConnectivityUpdateTask;
import ru.yandex.travel.spring.tx.ForcedRollbackTxManagerWrapper;
import ru.yandex.travel.task_processor.TaskProcessor;
import ru.yandex.travel.task_processor.TaskProcessorHelper;

@Configuration
@RequiredArgsConstructor
@EnableConfigurationProperties(TravellineConnectivityUpdateTaskConfigurationProperties.class)
public class TravellineConnectivityUpdateTaskConfiguration {
    private final TravellineService travellineService;
    private final HotelConnectionRepository hotelConnectionRepository;
    private final ForcedRollbackTxManagerWrapper forcedRollbackTxManagerWrapper;
    private final TravellineConnectivityUpdateTaskConfigurationProperties properties;

    @Bean
    public TravellineConnectivityUpdateTask travellineConnectivityUpdateTask() {
        return new TravellineConnectivityUpdateTask(travellineService, hotelConnectionRepository);
    }

    @Bean
    @Autowired
    @ConditionalOnProperty("travelline-connectivity-update-task.task-processor.enabled")
    public TaskProcessor<String> travellineConnectivityUpdateProcessor(TravellineConnectivityUpdateTask task) {
        return new TaskProcessor<>(
                task,
                task::updateConnections,
                forcedRollbackTxManagerWrapper,
                TaskProcessorHelper.createDefaultTxDefinition("travellineConnectivity"),
                properties.getTaskProcessor()
        );
    }

}
