package ru.yandex.travel.hotels.administrator.configuration;

import java.util.Map;

import com.google.common.collect.ImmutableMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.bolts.collection.Option;
import ru.yandex.travel.hotels.administrator.entity.HotelConnection;
import ru.yandex.travel.hotels.administrator.entity.HotelConnectionUpdate;
import ru.yandex.travel.hotels.administrator.entity.LegalDetails;
import ru.yandex.travel.hotels.administrator.entity.WorkflowEntityType;
import ru.yandex.travel.hotels.administrator.workflow.billingregistration.BillingRegistrationWorkflowHandler;
import ru.yandex.travel.hotels.administrator.workflow.step.handlers.CallGeoSearchWorkflowHandler;
import ru.yandex.travel.hotels.administrator.workflow.step.handlers.RegisterInBalanceWorkflowHandler;
import ru.yandex.travel.hotels.administrator.workflow.step.handlers.UpdateBalanceDataWorkflowHandler;
import ru.yandex.travel.hotels.administrator.workflow.step.handlers.VerifyClusteringWorkflowHandler;
import ru.yandex.travel.hotels.administrator.workflow.ticket.TicketWorkflowHandler;
import ru.yandex.travel.workflow.WorkflowEventHandler;
import ru.yandex.travel.workflow.WorkflowEventHandlerMatcher;

@Configuration
public class WorkflowEventHandlersConfiguration {

    @Autowired
    private WorkflowEventHandler<HotelConnection> hotelConnectionWorkflowEventHandler;

    @Autowired
    private WorkflowEventHandler<HotelConnectionUpdate> hotelConnectionUpdateWorkflowEventHandler;


    @Autowired
    private WorkflowEventHandler<LegalDetails> legalDetailsWorkflowEventHandler;

    @Autowired
    @Qualifier("genericErrorSupervisorWorkflowEventHandler")
    private WorkflowEventHandler<Void> genericSupervisorWorkflowEventHandler;

    @Autowired
    private RegisterInBalanceWorkflowHandler registerInBalanceWorkflowEventHandler;

    @Autowired
    private CallGeoSearchWorkflowHandler callGeoSearchWorkflowHandler;

    @Autowired
    private TicketWorkflowHandler ticketWorkflowHandler;

    @Autowired
    private VerifyClusteringWorkflowHandler verifyClusteringWorkflowHandler;

    @Autowired
    private BillingRegistrationWorkflowHandler billingRegistrationWorkflowHandler;

    @Autowired
    private UpdateBalanceDataWorkflowHandler updateBalanceDataWorkflowHandler;

    @Bean
    public WorkflowEventHandlerMatcher workflowEventHandlerMatcher() {
        Map<String, WorkflowEventHandler<?>> handlers = ImmutableMap.<String, WorkflowEventHandler<?>>builder()
                .put(WorkflowEntityType.HOTEL_CONNECTION.getDiscriminatorValue(), hotelConnectionWorkflowEventHandler)
                .put(WorkflowEntityType.HOTEL_CONNECTION_UPDATE.getDiscriminatorValue(), hotelConnectionUpdateWorkflowEventHandler)
                .put(WorkflowEntityType.LEGAL_DETAILS.getDiscriminatorValue(), legalDetailsWorkflowEventHandler)
                .put(WorkflowEntityType.GENERIC_SUPERVISOR.getDiscriminatorValue(), genericSupervisorWorkflowEventHandler)
                .put(WorkflowEntityType.REGISTER_IN_BALANCE_STEP.getDiscriminatorValue(), registerInBalanceWorkflowEventHandler)
                .put(WorkflowEntityType.VERIFY_CLUSTERING_STEP.getDiscriminatorValue(), verifyClusteringWorkflowHandler)
                .put(WorkflowEntityType.CALL_GEOSEARCH_STEP.getDiscriminatorValue(), callGeoSearchWorkflowHandler)
                .put(WorkflowEntityType.BILLING_REGISTRATION.getDiscriminatorValue(), billingRegistrationWorkflowHandler)
                .put(WorkflowEntityType.UPDATE_BALANCE_DATA_STEP.getDiscriminatorValue(), updateBalanceDataWorkflowHandler)
                .put(WorkflowEntityType.TICKET.getDiscriminatorValue(), ticketWorkflowHandler)
                .build();
        return (workflow, event) -> Option.ofNullable(handlers.get(workflow.getEntityType()));
    }

}
