package ru.yandex.travel.hotels.administrator.configuration;

import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.hotels.administrator.cache.AltayPublishingDictionary;
import ru.yandex.travel.hotels.administrator.cache.AltaySignalsDictionary;
import ru.yandex.travel.hotels.administrator.cache.HotelClusteringDictionary;
import ru.yandex.travel.hotels.administrator.cache.HotelFeedsDictionary;
import ru.yandex.travel.yt_lucene_index.YtLuceneIndexParams;

@Configuration
@EnableConfigurationProperties(YtCacheProperties.class)
public class YtCacheConfiguration {

    @Bean
    public HotelClusteringDictionary hotelClusteringDictionary(YtCacheProperties properties) {
        var base = fromBaseProperties(properties, HotelClusteringDictionary.HOTELS_CLUSTERING);
        base.setTablePath(properties.getHotelsClusteringYtTable());
        return new HotelClusteringDictionary(base);
    }

    @Bean
    public HotelFeedsDictionary hotelFeedsDictionary(YtCacheProperties properties) {
        var base = fromBaseProperties(properties, HotelFeedsDictionary.HOTEL_FEEDS);
        base.setTablePath(properties.getHotelsFeedsYtTable());
        return new HotelFeedsDictionary(base);
    }

    @Bean
    public AltaySignalsDictionary altaySignalDictionary(YtCacheProperties properties) {
        var base = fromBaseProperties(properties, AltaySignalsDictionary.ALTAY_SIGNALS);
        base.setTablePath(properties.getAltaySignalsYtTable());
        return new AltaySignalsDictionary(base);
    }

    @Bean
    public AltayPublishingDictionary altayPublishingDictionary(YtCacheProperties properties) {
        var base = fromBaseProperties(properties, AltayPublishingDictionary.ALTAY_PUBLISHING);
        base.setTablePath(properties.getAltayPublishingYtTable());
        return new AltayPublishingDictionary(base);
    }

    private static YtLuceneIndexParams fromBaseProperties(YtCacheProperties properties, String name) {
        YtLuceneIndexParams params = new YtLuceneIndexParams();
        params.setProxy(properties.getProxy());
        params.setToken(properties.getToken());
        params.setIndexPath(properties.getBaseLocalPath() + "/" + name + "-index");
        if (properties.getUpdateInterval() != null) {
            params.setUpdateInterval(properties.getUpdateInterval());
        }
        return params;
    }
}
