package ru.yandex.travel.hotels.administrator.configuration;

import java.time.Duration;
import java.util.List;

import javax.validation.constraints.NotEmpty;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@Data
@Validated
@ConfigurationProperties(prefix = "yt.cache", ignoreUnknownFields = false)
public class YtCacheProperties {
    @NotEmpty
    private List<String> proxy;
    @NotEmpty
    private String token;
    @NotEmpty
    private String hotelsClusteringYtTable;
    @NotEmpty
    private String hotelsFeedsYtTable;
    @NotEmpty
    private String altaySignalsYtTable;
    @NotEmpty
    private String altayPublishingYtTable;
    @NotEmpty
    private String baseLocalPath;
    private Duration updateInterval;
}
