package ru.yandex.travel.hotels.administrator.configuration;

import java.time.Duration;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@Getter
@Setter
@ConfigurationProperties(value = "yt-connection", ignoreUnknownFields = false)
@Validated
public class YtConnectionProperties {
    @NotEmpty
    private String token;
    @NotNull
    private Duration transactionDuration;
}
