package ru.yandex.travel.hotels.administrator.configuration;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.hotels.administrator.cache.HotelClusteringDictionary;
import ru.yandex.travel.hotels.administrator.repository.HotelConnectionRepository;
import ru.yandex.travel.hotels.administrator.repository.LegalDetailsRepository;
import ru.yandex.travel.hotels.administrator.service.Meters;
import ru.yandex.travel.hotels.administrator.task.HotelsYtPublishTask;
import ru.yandex.travel.spring.tx.ForcedRollbackTxManagerWrapper;
import ru.yandex.travel.task_processor.TaskProcessor;
import ru.yandex.travel.task_processor.TaskProcessorHelper;

@Configuration
@RequiredArgsConstructor
@EnableConfigurationProperties({YtConnectionProperties.class, YtPublishTaskProperties.class})
public class YtPublishTaskConfiguration {

    private final YtConnectionProperties connectionProperties;
    private final YtPublishTaskProperties publishTaskProperties;
    private final BillingServiceProperties billingServiceProperties;
    private final HotelConnectionRepository hotelConnectionRepository;
    private final LegalDetailsRepository legalDetailsRepository;
    private final HotelClusteringDictionary hotelClusteringDictionary;
    private final ForcedRollbackTxManagerWrapper forcedRollbackTxManagerWrapper;
    private final Meters meters;

    @Bean
    public HotelsYtPublishTask hotelsYtPublishTask() {
        return new HotelsYtPublishTask(
                connectionProperties,
                publishTaskProperties,
                billingServiceProperties,
                hotelConnectionRepository,
                legalDetailsRepository,
                hotelClusteringDictionary,
                meters
        );
    }

    @Bean
    @Autowired
    @ConditionalOnProperty("yt-publisher.task-processor.enabled")
    public TaskProcessor<String> hotelPublisherTaskProcessor(HotelsYtPublishTask hotelsYtPublishTask) {
        return new TaskProcessor<>(
                hotelsYtPublishTask,
                hotelsYtPublishTask::publishHotelsToYt,
                forcedRollbackTxManagerWrapper,
                TaskProcessorHelper.createDefaultTxDefinition("hotelsPublishTaskTxDefinition"),
                publishTaskProperties.getTaskProcessor());
    }
}
