package ru.yandex.travel.hotels.administrator.configuration;

import java.util.List;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

import ru.yandex.travel.task_processor.TaskProcessorProperties;

@Getter
@Setter
@ConfigurationProperties(value = "yt-publisher", ignoreUnknownFields = false)
@Validated
public class YtPublishTaskProperties {
    @NotEmpty
    private List<String> clusters;
    @NotEmpty
    private String whitelistTablePath;
    @NotEmpty
    private String agreementTablePath;
    @NotEmpty
    private String legalInfoTablePath;
    @NotEmpty
    private String contractInfoTablePath;
    @NotEmpty
    private String hotelConnectionsTablePath;

    private boolean useMatchedForWhitelist;

    private boolean autoDisableUnavailableHotels;

    @NotNull
    private TaskProcessorProperties taskProcessor;
}
