package ru.yandex.travel.hotels.administrator.configuration.partners;

import io.opentracing.Tracer;
import lombok.RequiredArgsConstructor;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.Dsl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.commons.logging.AsyncHttpClientWrapper;
import ru.yandex.travel.commons.retry.Retry;
import ru.yandex.travel.hotels.common.partners.bnovo.BNovoClient;
import ru.yandex.travel.hotels.common.partners.bnovo.DefaultBNovoClient;
import ru.yandex.travel.hotels.proto.EPartnerId;

@Configuration
@EnableConfigurationProperties(BnovoDefaultProperties.class)
@RequiredArgsConstructor
public class BnovoConfiguration {

    private static Logger DEFAULT_HTTP_LOGGER = LoggerFactory.getLogger(
            "ru.yandex.travel.hotels.administrator.HttpLogger");

    private final Tracer tracer;

    private final BnovoDefaultProperties properties;

    private final Retry retryHelper;

    @Bean
    public AsyncHttpClient bnovoAsyncClient() {
        return Dsl.asyncHttpClient(Dsl.config()
                .setThreadPoolName(EPartnerId.PI_BNOVO.toString() + "_POOL")
                .build());
    }

    @Bean
    public AsyncHttpClientWrapper bnovoAhcWrapper() {
        return new AsyncHttpClientWrapper(bnovoAsyncClient(),
                DEFAULT_HTTP_LOGGER, "bnovo", tracer, DefaultBNovoClient.getMethods().getNames());
    }

    @Bean
    public BNovoClient bnovoClient() {
        return new DefaultBNovoClient(bnovoAhcWrapper(), properties, retryHelper);
    }

}
