package ru.yandex.travel.hotels.administrator.configuration.partners;

import io.opentracing.Tracer;
import lombok.RequiredArgsConstructor;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.Dsl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.commons.logging.AsyncHttpClientWrapper;
import ru.yandex.travel.commons.retry.Retry;
import ru.yandex.travel.hotels.common.partners.travelline.DefaultTravellineClient;
import ru.yandex.travel.hotels.common.partners.travelline.TravellineClient;
import ru.yandex.travel.hotels.proto.EPartnerId;

@Configuration
@EnableConfigurationProperties(TravellineDefaultProperties.class)
@RequiredArgsConstructor
public class TravellineConfiguration {

    private static Logger DEFAULT_HTTP_LOGGER = LoggerFactory.getLogger(
            "ru.yandex.travel.hotels.administrator.HttpLogger");

    private final Tracer tracer;

    private final TravellineDefaultProperties properties;

    private final Retry retryHelper;

    @Bean
    public AsyncHttpClient travellineAsyncClient() {
        return Dsl.asyncHttpClient(Dsl.config()
                .setThreadPoolName(EPartnerId.PI_TRAVELLINE.toString() + "_POOL")
                .build());
    }

    @Bean
    public AsyncHttpClientWrapper travellineAhcWrapper() {
        return new AsyncHttpClientWrapper(travellineAsyncClient(),
                DEFAULT_HTTP_LOGGER, "travelline", tracer, DefaultTravellineClient.getMethods().getNames());
    }

    @Bean
    public TravellineClient travellineClient() {
        return new DefaultTravellineClient(travellineAhcWrapper(), properties, retryHelper);
    }

}
