package ru.yandex.travel.hotels.administrator.entity;

import java.time.Instant;
import java.util.UUID;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Version;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.UpdateTimestamp;

import ru.yandex.travel.hotels.proto.EPartnerId;

@Entity
@Table(name = "agreements")
@NoArgsConstructor
@AllArgsConstructor
@Builder
@Data
public class Agreement {
    @Id
    public UUID id;

    @Type(type = "custom-enum")
    public AgreementType agreementType;

    public String inn;

    public String hotelCode;

    @Type(type = "proto-enum")
    public EPartnerId partnerId;

    public String contactName;

    public String contactPosition;

    public String contactPhone;

    public String contactEmail;

    public boolean active;

    public boolean blocked;

    public String kpp;

    public String bic;

    public String paymentAccount;

    public Long balanceClientId;

    public Long balanceContractId;

    public Long balancePersonId;

    public String balanceExternalContractId;

    @CreationTimestamp
    public Instant createdAt;

    @UpdateTimestamp
    public Instant updatedAt;

    @Version
    public Integer version;
}
