package ru.yandex.travel.hotels.administrator.entity;

import java.time.Instant;
import java.util.UUID;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Version;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.UpdateTimestamp;

import ru.yandex.travel.hotels.administrator.workflow.proto.EBillingRegistrationState;
import ru.yandex.travel.workflow.entities.Workflow;
import ru.yandex.travel.workflow.entities.WorkflowEntity;

@Entity
@Table(name = "billing_registrations")
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class BillingRegistration implements WorkflowEntity<EBillingRegistrationState> {
    @Id
    private UUID id;

    @Type(type = "proto-enum")
    private EBillingRegistrationState state;

    @OneToOne
    private Workflow workflow;

    private UUID parentWorkflowId;

    @OneToOne
    private LegalDetails legalDetails;

    private Long clientId;

    private Long personId;

    private Long contractId;

    private String externalContractId;

    @CreationTimestamp
    private Instant createdAt;

    @UpdateTimestamp
    private Instant updatedAt;

    private Instant registeredAt;

    private Instant lastTransitionAt;

    @Version
    private Integer version;

    @Override
    public String getEntityType() {
        return WorkflowEntityType.BILLING_REGISTRATION.getDiscriminatorValue();
    }
}
