package ru.yandex.travel.hotels.administrator.entity;

import java.time.Instant;

import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;

import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Type;

import ru.yandex.travel.hotels.proto.EPartnerId;

@Entity
@DiscriminatorValue(value = "call_geosearch_step")
@Getter
@Setter
public class CallGeoSearchStep extends HotelConnectionStep {

    private String hotelCode;

    private String hotelConnectionStTicket;

    @Type(type = "proto-enum")
    private EPartnerId partnerId;

    private String hotelName;

    private Long permalink;

    private Instant lastGeoSearchCallAt;

    @Override
    public String getEntityType() {
        return WorkflowEntityType.CALL_GEOSEARCH_STEP.getDiscriminatorValue();
    }
}
