package ru.yandex.travel.hotels.administrator.entity;

import java.math.BigDecimal;
import java.time.Instant;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Version;

import lombok.Getter;
import lombok.Setter;

@Entity
@Table(name = "commissions")
@Getter
@Setter
public class Commission {

    @Id
    @GeneratedValue(
            strategy = GenerationType.SEQUENCE,
            generator = "hotel_agreements_id_seq"
    )
    @SequenceGenerator(
            name = "hotel_agreements_id_seq",
            sequenceName = "hotel_agreements_id_seq",
            allocationSize = 1
    )
    private Long id;

    @ManyToOne
    private HotelConnection hotelConnection;

    private Instant agreementStartDate;

    private BigDecimal orderConfirmedRate;

    private BigDecimal orderRefundedRate;

    private Instant agreementEndDate;

    private boolean enabled;

    private int priority;

    @Version
    private Integer version;
}
