package ru.yandex.travel.hotels.administrator.entity;

import java.time.Instant;
import java.util.UUID;

import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Version;

import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.Type;

import ru.yandex.travel.hotels.administrator.workflow.proto.EConnectionStepState;
import ru.yandex.travel.workflow.entities.Workflow;
import ru.yandex.travel.workflow.entities.WorkflowEntity;

@Entity
@Table(name = "connection_steps")
@Inheritance(strategy = InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name = "step_type")
@Getter
@Setter
public abstract class ConnectionStep implements WorkflowEntity<EConnectionStepState> {

    @Id
    private UUID id;

    @Type(type = "proto-enum")
    private EConnectionStepState state;

    @OneToOne
    private Workflow workflow;

    @CreationTimestamp
    private Instant createdAt;

    private Instant lastTransitionAt;

    private Instant checkedAt;

    private String stTicket;

    private boolean ticketResultFetched;

    private UUID parentWorkflowId;

    @Version
    private Integer version;

    @Override
    public Instant getLastTransitionAt() {
        if (lastTransitionAt == null) {
            return createdAt;
        }
        return lastTransitionAt;
    }

    public static <T extends ConnectionStep> void initNewStep(T step) {
        step.setId(UUID.randomUUID());
        step.setState(EConnectionStepState.CSS_NEW);
    }
}
