package ru.yandex.travel.hotels.administrator.entity;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

import javax.annotation.Nullable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Version;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.UpdateTimestamp;
import org.hibernate.envers.Audited;
import org.hibernate.envers.NotAudited;

import ru.yandex.travel.hotels.administrator.service.partners.model.HotelDetailsDTO;
import ru.yandex.travel.hotels.administrator.workflow.proto.EHotelConnectionState;
import ru.yandex.travel.hotels.proto.EPartnerId;
import ru.yandex.travel.orders.commons.proto.EVat;
import ru.yandex.travel.workflow.entities.Workflow;
import ru.yandex.travel.workflow.entities.WorkflowEntity;

import static ru.yandex.travel.hotels.administrator.entity.WorkflowEntityType.HOTEL_CONNECTION;

@Entity
@Audited
@Table(name = "hotel_connections")
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class HotelConnection implements WorkflowEntity<EHotelConnectionState> {

    public String hotelCode;

    /**
     * For Bnovo - the hoteld id that the user sees in bnovo app.
     */
    @Nullable
    public String externalHotelId;

    @Type(type = "proto-enum")
    public EPartnerId partnerId;

    public String hotelName;

    public Long permalink;

    public String stTicket;

    public boolean readyForOrchestrator;

    public boolean readyForOffercache;

    public boolean clusteringVerified;

    public boolean legalDetailsRegistered;

    public boolean geoSearchCalled;

    public boolean availableAtPartner;

    @Type(type = "custom-enum")
    public HotelTaxType taxType;

    @Type(type = "proto-enum")
    public EVat vatType;

    @Id
    public UUID id;

    @Type(type = "proto-enum")
    public EHotelConnectionState state;

    @Type(type = "custom-enum")
    public UnpublishedReason unpublishedReason;

    @OneToOne
    @NotAudited
    public Workflow workflow;

    @CreationTimestamp
    public Instant createdAt;

    @UpdateTimestamp
    public Instant updatedAt;

    public Instant firstPublishAt;

    public Instant lastTransitionAt;

    @OneToMany(mappedBy = "hotelConnection")
    @NotAudited
    public List<HotelConnectionStep> connectionSteps;

    @OneToMany(mappedBy = "hotelConnection")
    @NotAudited
    public List<Commission> commissions;

    @ManyToOne
    public LegalDetails legalDetails;

    @Type(type = "jsonb-object")
    @Column(name = "hotel_details_dto")
    public HotelDetailsDTO hotelDetailsDTO;

    public String accountantEmail;  // list of emails with ; delimiter

    public String reservationPhone;

    public String address;

    public String cityName;

    public String contractPersonName;

    public String contractPersonPosition;

    public String contractPersonPhone;

    public String contractPersonEmail;  // list of emails with ; delimiter

    public boolean paperAgreement;

    @Version
    public Integer version;

    @Override
    public String getEntityType() {
        return HOTEL_CONNECTION.getDiscriminatorValue();
    }

    @Override
    public Instant getLastTransitionAt() {
        if (lastTransitionAt == null) {
            return createdAt;
        }
        return lastTransitionAt;
    }

    public List<String> getAccountantEmails() {
        return accountantEmail != null ? Arrays.asList(accountantEmail.split(";")) : Collections.emptyList();
    }

    public List<String> getContractPersonEmails() {
        return contractPersonEmail != null ? Arrays.asList(contractPersonEmail.split(";")) : Collections.emptyList();
    }
}
