package ru.yandex.travel.hotels.administrator.entity;

import java.time.Instant;
import java.util.UUID;

import javax.annotation.Nullable;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Version;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.UpdateTimestamp;

import ru.yandex.travel.hotels.administrator.service.partners.model.HotelDetailsDTO;
import ru.yandex.travel.hotels.administrator.workflow.proto.EHotelConnectionState;
import ru.yandex.travel.hotels.administrator.workflow.proto.EHotelConnectionUpdateState;
import ru.yandex.travel.hotels.proto.EPartnerId;
import ru.yandex.travel.orders.commons.proto.EVat;
import ru.yandex.travel.workflow.entities.Workflow;
import ru.yandex.travel.workflow.entities.WorkflowEntity;

import static ru.yandex.travel.hotels.administrator.entity.WorkflowEntityType.HOTEL_CONNECTION_UPDATE;

@Entity
@Table(name = "hotel_connection_updates")
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class HotelConnectionUpdate implements WorkflowEntity<EHotelConnectionUpdateState> {

    @Id
    private UUID id;

    private String stTicket;

    private boolean financialEventsUpdated;

    private boolean legalDetailsPublished;

    @Type(type = "jsonb-object")
    private HotelDetailsDTO hotelDetailsDto;

    @ManyToOne
    private HotelConnection hotelConnection;

    private String hotelCode;

    @Nullable
    private String externalHotelId;

    @Type(type = "proto-enum")
    private EPartnerId partnerId;

    @Type(type = "proto-enum")
    private EHotelConnectionState originalHotelConnectionState;

    private String accountantEmail;

    private String reservationPhone;

    private String address;

    private String cityName;

    private String contractPersonName;

    private String contractPersonPosition;

    private String contractPersonPhone;

    private String contractPersonEmail;

    @Type(type = "custom-enum")
    private HotelTaxType taxType;

    @Type(type = "proto-enum")
    private EVat vatType;

    private String inn;

    private String kpp;

    private String bic;

    private String bankName;

    private String correspondingAccount;

    private String paymentAccount;

    private String legalName;

    private String fullLegalName;

    private String legalPostCode;

    private String legalAddress;

    private String originalLegalAddress;

    private boolean legalAddressUnified;

    private String postCode;

    private String postAddress;

    private boolean offerAccepted;

    private String legalPhone;

    @Type(type = "proto-enum")
    private EHotelConnectionUpdateState state;

    @OneToOne
    private Workflow workflow;

    @CreationTimestamp
    private Instant createdAt;

    @UpdateTimestamp
    private Instant updatedAt;

    private Instant lastTransitionAt;

    @Version
    private Integer version;

    @Override
    public String getEntityType() {
        return HOTEL_CONNECTION_UPDATE.getDiscriminatorValue();
    }

    @Override
    public Instant getLastTransitionAt() {
        if (lastTransitionAt == null) {
            return createdAt;
        }
        return lastTransitionAt;
    }
}
