package ru.yandex.travel.hotels.administrator.entity;

import java.time.Instant;
import java.util.List;
import java.util.UUID;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Version;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.UpdateTimestamp;
import org.hibernate.envers.Audited;
import org.hibernate.envers.NotAudited;

import ru.yandex.travel.hotels.administrator.workflow.proto.ELegalDetailsState;
import ru.yandex.travel.hotels.proto.EPartnerId;
import ru.yandex.travel.workflow.entities.Workflow;
import ru.yandex.travel.workflow.entities.WorkflowEntity;

import static ru.yandex.travel.hotels.administrator.entity.WorkflowEntityType.LEGAL_DETAILS;

@Entity
@Audited
@Table(name = "legal_details")
@NoArgsConstructor
@AllArgsConstructor
@Builder
@Getter
@Setter
public class LegalDetails implements WorkflowEntity<ELegalDetailsState> {

    @Type(type = "proto-enum")
    public EPartnerId partnerId;

    public String inn;

    public String ogrn;

    public String kpp;

    public String bic;

    public String bankName;

    public String correspondingAccount;

    public String paymentAccount;

    public String legalName;

    public String fullLegalName;

    public String legalPostCode;

    public String legalAddress;

    public boolean legalAddressUnified;

    public String postCode;

    public String postAddress;

    public String phone;

    public boolean blockedByYandex;

    public boolean offerAccepted;

    public Long balanceClientId;

    public Long balancePersonId;

    public Long balanceContractId;

    public String balanceExternalContractId;

    public Instant registeredAt;

    public boolean registeredInBalance;

    public String stTicket;

    public boolean sendEmptyOrdersReport;

    public UUID hotelConnectionUpdateId;

    public boolean billingActive;

    public boolean billingSigned;

    public boolean billingOfferAccepted;

    public boolean billingCancelled;

    public boolean billingDeactivated;

    public boolean billingSuspended;

    public Instant flagsSynchronizedAt;

    public boolean managedByAdministrator;

    @OneToMany(mappedBy = "legalDetails")
    public List<HotelConnection> hotelConnections;

    @Id
    public UUID id;

    @Type(type = "proto-enum")
    public ELegalDetailsState state;

    @OneToOne
    @NotAudited
    public Workflow workflow;

    @CreationTimestamp
    public Instant createdAt;

    @UpdateTimestamp
    public Instant updatedAt;

    public Instant lastTransitionAt;

    @Version
    public Integer version;

    @OneToMany(mappedBy = "legalDetails")
    @NotAudited
    public List<LegalDetailsConnectionStep> connectionSteps;

    @Override
    public String getEntityType() {
        return LEGAL_DETAILS.getDiscriminatorValue();
    }

    @Override
    public Instant getLastTransitionAt() {
        if (lastTransitionAt == null) {
            return createdAt;
        }
        return lastTransitionAt;
    }
}
