package ru.yandex.travel.hotels.administrator.entity;

import javax.persistence.Entity;
import javax.persistence.ManyToOne;

import lombok.Getter;
import lombok.Setter;

@Entity
@Getter
@Setter
public abstract class LegalDetailsConnectionStep extends ConnectionStep {

    @ManyToOne
    private LegalDetails legalDetails;

    public static <T extends LegalDetailsConnectionStep> T initNewStep(T step, LegalDetails legalDetails) {
        initNewStep(step);
        step.setLegalDetails(legalDetails);
        step.setParentWorkflowId(legalDetails.getWorkflow().getId());
        return step;
    }
}
