package ru.yandex.travel.hotels.administrator.entity;

import java.time.Instant;
import java.util.UUID;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Version;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.UpdateTimestamp;

@Entity
@Table(name = "legal_details_updates")
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class LegalDetailsUpdate {
    @Id
    @GeneratedValue(
            strategy = GenerationType.SEQUENCE,
            generator = "legal_details_updates_id_seq"
    )
    @SequenceGenerator(
            name = "legal_details_updates_id_seq",
            sequenceName = "legal_details_updates_id_seq",
            allocationSize = 1
    )
    private Long id;

    @ManyToOne
    private HotelConnection hotelConnection;

    @ManyToOne
    private LegalDetails legalDetails;

    private UUID hotelConnectionUpdateId;

    @Type(type = "custom-enum")
    private LegalDetailsUpdateState state;

    @CreationTimestamp
    private Instant createdAt;

    @UpdateTimestamp
    private Instant updatedAt;

    private String inn;

    private String kpp;

    private String bic;

    private String paymentAccount;

    private String legalName;

    private String fullLegalName;

    private String bankName;

    private String correspondingAccount;

    private String legalPostCode;

    private String legalAddress;

    private String originalLegalAddress;

    private boolean legalAddressUnified;

    private String postCode;

    private String postAddress;

    private String phone;

    @Version
    private Integer version;
}
