package ru.yandex.travel.hotels.administrator.entity;

import java.time.Instant;

import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;

import lombok.Getter;
import lombok.Setter;

@Entity
@DiscriminatorValue(value = "register_in_balance")
@Getter
@Setter
public class RegisterInBalanceStep extends LegalDetailsConnectionStep {

    private Long balanceClientId;

    private Long balanceContractId;

    private Instant registeredAt;

    private String legalName;

    private String legalDetailsStTicket;

    @Override
    public String getEntityType() {
        return WorkflowEntityType.REGISTER_IN_BALANCE_STEP.getDiscriminatorValue();
    }
}
