package ru.yandex.travel.hotels.administrator.entity;

import java.time.Instant;
import java.util.UUID;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Version;

import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.UpdateTimestamp;

import ru.yandex.travel.hotels.administrator.workflow.proto.ETicketState;
import ru.yandex.travel.workflow.entities.Workflow;
import ru.yandex.travel.workflow.entities.WorkflowEntity;

@Entity
@Table(name = "tickets")
@Getter
@Setter
public class Ticket implements WorkflowEntity<ETicketState> {

    @Id
    private UUID id;

    @OneToOne
    private Workflow workflow;

    private Instant lastTransitionAt;

    @Type(type = "proto-enum")
    private ETicketState state;

    @CreationTimestamp
    private Instant createdAt;
    @UpdateTimestamp
    private Instant updatedAt;

    private String issueId;

    @Version
    private Integer version;

    @Override
    public String getEntityType() {
        return WorkflowEntityType.TICKET.getDiscriminatorValue();
    }

    public Instant getLastTransitionAt() {
        if (lastTransitionAt == null) {
            return createdAt;
        }
        return lastTransitionAt;
    }
}
